#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

void zameni_double(double *a, double *b) {
    double temp = *a;
    *a = *b;
    *b = temp;
}

void zameni_int(int *a, int *b) {
    int temp = *a;
    *a = *b;
    *b = temp;
}

void sortiraj_jarbole(int n, double *x, double *h, int *orig_indeksi) {
    for (int i = 0; i < n - 1; i++) {
        for (int j = 0; j < n - i - 1; j++) {
            if (x[j] > x[j+1]) {
                zameni_double(&x[j], &x[j+1]);
                zameni_double(&h[j], &h[j+1]);
                zameni_int(&orig_indeksi[j], &orig_indeksi[j+1]);
            }
        }
    }
}

double distanca(double x1, double y1, double x2, double y2){
    return sqrt(pow(x1-x2,2)+pow(y1-y2,2));
}

double nadji_najmanje(double xa, double ha, double xb, double hb, double xv, double hv){
    double hp=(ha+hb-(xb-xa))/2.0;
    double xp=xa+(ha-hp);
    double min_d=FLT_MAX;
    int nadjeno=0;

    if(hp>=hv){
        double d=distanca(xp,hp,xv,hv);
        if(d<min_d)min_d=d;
        nadjeno=1;
    }

    double x_levo=xa+ha-hv;
    if(x_levo>=xa && x_levo<=xp){
        double d=fabs(xv-x_levo);
        if(d<min_d)min_d=d;
        nadjeno=1;
    }

    double x_desno=xb-(hb-hv);
    if(x_desno>=xp && x_desno<=xb){
        double d=fabs(xv-x_desno);
        if(d<min_d)min_d=d;
        nadjeno=1;
    }

    if(nadjeno){
        return min_d;
    }else{
        return FLT_MAX;
    }
}

int main(){
    int n;
    if(scanf("%d",&n)!=1)return 1;

    double *x=(double*)malloc(n*sizeof(double));
    double *h=(double*)malloc(n*sizeof(double));
    int *orig_indeksi=(int*)malloc(n*sizeof(int));
    double *rezultati=(double*)malloc(n*sizeof(double));

    if(x==NULL || h==NULL || orig_indeksi==NULL || rezultati==NULL){
        free(x);free(h);free(orig_indeksi);free(rezultati);return 1;
    }

    for(int i=0;i<n;i++){
        if(scanf("%lf",&x[i])!=1) { return 1; }
        orig_indeksi[i]=i;
    }
    for(int i=0;i<n;i++){
        if(scanf("%lf",&h[i])!=1) { return 1; }
    }

    sortiraj_jarbole(n, x, h, orig_indeksi);
    
    for(int i=0;i<n;i++){
        double min_d=FLT_MAX;
        double xi=x[i];
        double hi=h[i];
        int nadjeno=0;

        for(int j=0;j<n;j++){
            if(i==j)continue;
            
            if(h[j]>=hi){
                double d=distanca(xi,hi,x[j],h[j]);
                if(d<min_d){
                    min_d=d;
                    nadjeno=1;
                }
            }
        }

        if(i>0){
            double d=nadji_najmanje(x[i-1],h[i-1],x[i],h[i],xi,hi);
            if(d<min_d){
                min_d=d;
                nadjeno=1;
            }
        }

        if(i<n-1){
            double d=nadji_najmanje(x[i],h[i],x[i+1],h[i+1],xi,hi);
            if(d<min_d){
                min_d=d;
                nadjeno=1;
            }
        }

        if(nadjeno){
            rezultati[orig_indeksi[i]]=min_d;
        }else{
            rezultati[orig_indeksi[i]]=-1.0;
        }
    }

    for(int i=0;i<n;i++){
        double min_d=rezultati[i];
        if(min_d<0){
             printf("-1\n");
        }else{
            double zaokruzeno = floor(min_d + 0.5);
            
            if(fabs(min_d - zaokruzeno) < 1e-9){
                printf("%.0f\n", zaokruzeno);
            }else{
                printf("%.6f\n", min_d);
            }
        }
    }

    free(x);
    free(h);
    free(orig_indeksi);
    free(rezultati);
    return 0;
}